% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackgroundSubtractionFunctions.R
\docType{methods}
\name{nSolverBackground,RccSet-method}
\alias{nSolverBackground,RccSet-method}
\alias{nSolverBackground}
\title{nSolver Analysis Software background estimation}
\usage{
\S4method{nSolverBackground}{RccSet}(rccSet, stringency = 1, shrink = TRUE,
  w1 = 2.18, inputMatrix = c("posCtrlData", "exprs"))
}
\arguments{
\item{rccSet}{NanoString RccSet object}

\item{stringency}{Multiplier with which to adjust final values.}

\item{shrink}{Boolean specifying if probe-specific estimates should be shrunken towards
their global mean.}

\item{w1}{Shrink weight "w1".}

\item{inputMatrix}{Name of the matrix in the RccSet's assayData to use as input for calculating
background estimates (one of "exprs" or "posCtrlData"). If posCtrlData is
specified but not present in the assayData, an error will be generated.}
}
\value{
A matrix containing lane- and probe-specific background estimates.
}
\description{
Calculates initial probe- and lane-specific background estimates using an
algorithm that mimics the implementation in NanoString's nSolver Analysis
Software (see details below for the exact algorithm).
}
\details{
The mean values for each blank lane (not including positive control probes)
are computed from the original data, and a vector of probe-specific
background is established by taking the rowMeans of the blank measurements
for each probe after subtracting out these values. If shrink=TRUE, the
vector is adjusted via the following formula (where 'probe.bg' represents
the vector):

\preformatted{w2 <- 1/length(blanks)
probe.bg <- (w1*probe.bg + w2*mean(probe.bg)) / (w1 + w2)
}

This probe-specific background is further adjusted by subtracting the mean
of its values for the negative control probes. A lane-specific "affinity" is
calculated for all lanes in the original data by taking the colMeans of the
negative control probe values in the original data, and background estimates
for each probe and lane in the original data are computed by summing the
corresponding probe-specific background and lane-specific affinity. Any
resulting values less than zero are set to zero, and the last step before
returning these values is to multiply them by the given stringency.
}
\seealso{
\code{\link{getBackground}}, \code{\link{subtractBackground}}
}
\author{
Dorothee Nickles, Thomas Sandmann
}
