% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKmknn.R
\name{buildKmknn}
\alias{buildKmknn}
\title{Pre-cluster points with k-means}
\usage{
buildKmknn(
  X,
  transposed = FALSE,
  distance = c("Euclidean", "Manhattan", "Cosine"),
  ...
)
}
\arguments{
\item{X}{A numeric matrix where rows correspond to data points and columns correspond to variables (i.e., dimensions).}

\item{transposed}{Logical scalar indicating whether \code{X} is transposed, i.e., rows are variables and columns are data points.}

\item{distance}{String specifying the type of distance to use.}

\item{...}{Further arguments to pass to \code{\link{kmeans}}.}
}
\value{
A \linkS4class{KmknnIndex} object containing indexing structures for the KMKNN search.
}
\description{
Perform k-means clustering in preparation for a KMKNN nearest-neighbors search.
}
\details{
This function is automatically called by \code{\link{findKmknn}} and related functions. 
However, it can be called directly by the user to save time if multiple queries are to be performed to the same \code{X}.

Points in \code{X} are reordered to improve data locality during the nearest-neighbor search.
Specifically, points in the same cluster are contiguous and ordered by increasing distance from the cluster center.

After k-means clustering, the function will store the coordinates of the cluster center in the output object.
In addition, it records a list of extra information of length equal to the number of clusters.
Each entry corresponds a cluster (let's say cluster \eqn{j}) and is a list of length 2.
The first element is an integer scalar containing the zero-index of the first point in the reordered data matrix that is assigned to \eqn{j}.
The second element is a numeric vector containing the distance of each point in the cluster from the cluster center.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
out <- buildKmknn(Y)
out

}
\seealso{
\code{\link{kmeans}}, for optional arguments.
    
\linkS4class{KmknnIndex} for details on the output class.

\code{\link{findKmknn}}, \code{\link{queryKmknn}} and \code{\link{findNeighbors}}, for dependent functions.
}
\author{
Aaron Lun
}
