# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ChannelList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, branded_channel_sid):
        """
        Initialize the ChannelList

        :param Version version: Version that contains the resource
        :param branded_channel_sid: Branded Channel Sid.

        :returns: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelList
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelList
        """
        super(ChannelList, self).__init__(version)

        # Path Solution
        self._solution = {'branded_channel_sid': branded_channel_sid, }
        self._uri = '/BrandedChannels/{branded_channel_sid}/Channels'.format(**self._solution)

    def create(self, phone_number_sid):
        """
        Create the ChannelInstance

        :param unicode phone_number_sid: Phone Number Sid to be branded.

        :returns: The created ChannelInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelInstance
        """
        data = values.of({'PhoneNumberSid': phone_number_sid, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ChannelInstance(
            self._version,
            payload,
            branded_channel_sid=self._solution['branded_channel_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.ChannelList>'


class ChannelPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ChannelPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param branded_channel_sid: Branded Channel Sid.

        :returns: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelPage
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelPage
        """
        super(ChannelPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ChannelInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelInstance
        """
        return ChannelInstance(
            self._version,
            payload,
            branded_channel_sid=self._solution['branded_channel_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.ChannelPage>'


class ChannelInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, branded_channel_sid):
        """
        Initialize the ChannelInstance

        :returns: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_channel.channel.ChannelInstance
        """
        super(ChannelInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'business_sid': payload.get('business_sid'),
            'brand_sid': payload.get('brand_sid'),
            'branded_channel_sid': payload.get('branded_channel_sid'),
            'phone_number_sid': payload.get('phone_number_sid'),
            'phone_number': payload.get('phone_number'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'branded_channel_sid': branded_channel_sid, }

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def business_sid(self):
        """
        :returns: Business Sid.
        :rtype: unicode
        """
        return self._properties['business_sid']

    @property
    def brand_sid(self):
        """
        :returns: Brand Sid.
        :rtype: unicode
        """
        return self._properties['brand_sid']

    @property
    def branded_channel_sid(self):
        """
        :returns: Branded Channel Sid.
        :rtype: unicode
        """
        return self._properties['branded_channel_sid']

    @property
    def phone_number_sid(self):
        """
        :returns: Phone Number Sid to be branded.
        :rtype: unicode
        """
        return self._properties['phone_number_sid']

    @property
    def phone_number(self):
        """
        :returns: Twilio number to assign to the Branded Channel
        :rtype: unicode
        """
        return self._properties['phone_number']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.ChannelInstance>'
