// ----------------------------------------------------------------------------
// -                        Open3D: www.open3d.org                            -
// ----------------------------------------------------------------------------
// The MIT License (MIT)
//
// Copyright (c) 2018-2021 www.open3d.org
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------------------------------

#pragma once
// These are internal helper functions

#include <imgui.h>

#include <string>
#include <vector>

#include "open3d/visualization/gui/Gui.h"

namespace open3d {
namespace visualization {
namespace gui {

class Color;

// These functions are here, because ImVec4 requires imgui.h, and can't be
// forward-declared because we need to know the size, since it is a return
// value. Since imgui.h is an implementation detail, we can't put this function
// in Color or it would pull in imgui.h pretty much everywhere that gui is used.
ImVec4 colorToImgui(const Color& color);
uint32_t colorToImguiRGBA(const Color& color);

std::string FindFontPath(std::string font, FontStyle style);

}  // namespace gui
}  // namespace visualization
}  // namespace open3d
