/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/bytecodeText")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BytecodeTextTestGenerated extends AbstractBytecodeTextTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    @TestMetadata("accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
    }

    @TestMetadata("accessorForProtected.kt")
    public void testAccessorForProtected() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
    }

    @TestMetadata("accessorNaming.kt")
    public void testAccessorNaming() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
    }

    public void testAllFilesPresentInBytecodeText() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
    }

    @TestMetadata("annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
    }

    @TestMetadata("annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
    }

    @TestMetadata("annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
    }

    @TestMetadata("annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
    }

    @TestMetadata("boxedNotNumberTypeOnUnboxing.kt")
    public void testBoxedNotNumberTypeOnUnboxing() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
    }

    @TestMetadata("bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
    }

    @TestMetadata("charConstant.kt")
    public void testCharConstant() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
    }

    @TestMetadata("componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
    }

    @TestMetadata("constClosureOptimization.kt")
    public void testConstClosureOptimization() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
    }

    @TestMetadata("constCoroutine.kt")
    public void testConstCoroutine() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/constCoroutine.kt");
    }

    @TestMetadata("defaultMethodBody.kt")
    public void testDefaultMethodBody() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
    }

    @TestMetadata("doNotStoreNullForTmpInDestructuring.kt")
    public void testDoNotStoreNullForTmpInDestructuring() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
    }

    @TestMetadata("doNotStoreNullsForCapturedVars.kt")
    public void testDoNotStoreNullsForCapturedVars() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
    }

    @TestMetadata("falseSmartCast.kt")
    public void testFalseSmartCast() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
    }

    @TestMetadata("inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
    }

    @TestMetadata("inlineJavaConstantFromSubclass.kt")
    public void testInlineJavaConstantFromSubclass() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
    }

    @TestMetadata("inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
    }

    @TestMetadata("inlineProtectedJavaConstantFromOtherPackage.kt")
    public void testInlineProtectedJavaConstantFromOtherPackage() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
    }

    @TestMetadata("intConstantNotNull.kt")
    public void testIntConstantNotNull() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
    }

    @TestMetadata("intConstantNullable.kt")
    public void testIntConstantNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
    }

    @TestMetadata("intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
    }

    @TestMetadata("intConstantSafeCall.kt")
    public void testIntConstantSafeCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
    }

    @TestMetadata("intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
    }

    @TestMetadata("interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
    }

    @TestMetadata("isArrayOf.kt")
    public void testIsArrayOf() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
    }

    @TestMetadata("javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
    }

    @TestMetadata("javaStatics.kt")
    public void testJavaStatics() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
    }

    @TestMetadata("jvmField.kt")
    public void testJvmField() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
    }

    @TestMetadata("kt10259.kt")
    public void testKt10259() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
    }

    @TestMetadata("kt10259_2.kt")
    public void testKt10259_2() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
    }

    @TestMetadata("kt10259_3.kt")
    public void testKt10259_3() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
    }

    @TestMetadata("kt2202.kt")
    public void testKt2202() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
    }

    @TestMetadata("kt2887.kt")
    public void testKt2887() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
    }

    @TestMetadata("kt3845.kt")
    public void testKt3845() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
    }

    @TestMetadata("kt5016.kt")
    public void testKt5016() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
    }

    @TestMetadata("kt5016int.kt")
    public void testKt5016int() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
    }

    @TestMetadata("kt5016intOrNull.kt")
    public void testKt5016intOrNull() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
    }

    @TestMetadata("kt7188.kt")
    public void testKt7188() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
    }

    @TestMetadata("kt7769.kt")
    public void testKt7769() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
    }

    @TestMetadata("kt9603.kt")
    public void testKt9603() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
    }

    @TestMetadata("maxStackAfterOptimizations.kt")
    public void testMaxStackAfterOptimizations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
    }

    @TestMetadata("noFlagAnnotations.kt")
    public void testNoFlagAnnotations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
    }

    @TestMetadata("noInlineJavaProtectedConstants.kt")
    public void testNoInlineJavaProtectedConstants() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noInlineJavaProtectedConstants.kt");
    }

    @TestMetadata("noNumberCheckCast.kt")
    public void testNoNumberCheckCast() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
    }

    @TestMetadata("noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
    }

    @TestMetadata("noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
    public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
    }

    @TestMetadata("noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
    }

    @TestMetadata("nopsInDoWhile.kt")
    public void testNopsInDoWhile() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
    }

    @TestMetadata("partMembersCall.kt")
    public void testPartMembersCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
    }

    @TestMetadata("partMembersInline.kt")
    public void testPartMembersInline() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
    }

    @TestMetadata("preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
    }

    @TestMetadata("prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
    }

    @TestMetadata("privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
    }

    @TestMetadata("redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
    }

    @TestMetadata("redundantInitializer.kt")
    public void testRedundantInitializer() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
    }

    @TestMetadata("redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
    }

    @TestMetadata("redundantValInitializer.kt")
    public void testRedundantValInitializer() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
    }

    @TestMetadata("reifiedAsCheck.kt")
    public void testReifiedAsCheck() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
    }

    @TestMetadata("reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
    }

    @TestMetadata("reifiedIsCheck.kt")
    public void testReifiedIsCheck() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
    }

    @TestMetadata("reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
    }

    @TestMetadata("safeAsWithMutable.kt")
    public void testSafeAsWithMutable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
    }

    @TestMetadata("superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
    }

    @TestMetadata("topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArgumentOrder extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentReorder.kt")
        public void testArgumentReorder() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/argumentReorder.kt");
        }

        @TestMetadata("argumentReorderWithDefault.kt")
        public void testArgumentReorderWithDefault() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/argumentReorderWithDefault.kt");
        }

        @TestMetadata("sameOrder.kt")
        public void testSameOrder() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
        }

        @TestMetadata("sameOrderWithDefault.kt")
        public void testSameOrderWithDefault() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/assert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Assert extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAssert() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jvmCrossinline.kt")
        public void testJvmCrossinline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
        }

        @TestMetadata("jvmCrossinlineAssertInLambda.kt")
        public void testJvmCrossinlineAssertInLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
        }

        @TestMetadata("jvmInline.kt")
        public void testJvmInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
        }

        @TestMetadata("jvmInlineLambda.kt")
        public void testJvmInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/boxing")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Boxing extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBoxing() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("crossinlineSuspend.kt")
        public void testCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
        }

        @TestMetadata("inlineSuspend.kt")
        public void testInlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
        }

        @TestMetadata("suspend.kt")
        public void testSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxingOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boxingAndEquals.kt")
        public void testBoxingAndEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
        }

        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
        }

        @TestMetadata("inlineClassesAndInlinedLambda.kt")
        public void testInlineClassesAndInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
        }

        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
        }

        @TestMetadata("kClassInAnnotation.kt")
        public void testKClassInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
        }

        @TestMetadata("kClassInAnnotationEscaping.kt")
        public void testKClassInAnnotationEscaping() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
        }

        @TestMetadata("kt15862.kt")
        public void testKt15862() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
        }

        @TestMetadata("kt15862_2.kt")
        public void testKt15862_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
        }

        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
        }

        @TestMetadata("kt7224.kt")
        public void testKt7224() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
        }

        @TestMetadata("maxMinBy.kt")
        public void testMaxMinBy() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinBy.kt");
        }

        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
        }

        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
        }

        @TestMetadata("safeCallToPrimitiveEquality.kt")
        public void testSafeCallToPrimitiveEquality() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality.kt");
        }

        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
        }

        @TestMetadata("severalInlines.kt")
        public void testSeveralInlines() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
        }

        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
        }

        @TestMetadata("unsignedRangeIteratorSpecialization.kt")
        public void testUnsignedRangeIteratorSpecialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
        }

        @TestMetadata("variableClash.kt")
        public void testVariableClash() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BuiltinFunctions extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBuiltinFunctions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
        }

        @TestMetadata("contains.kt")
        public void testContains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
        }

        @TestMetadata("removeAt.kt")
        public void testRemoveAt() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
        }

        @TestMetadata("size.kt")
        public void testSize() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GenericParameterBridge extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
            }

            public void testAllFilesPresentInGenericParameterBridge() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("IntMC.kt")
            public void testIntMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
            }

            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
            }

            @TestMetadata("mutableSetInterfaces.kt")
            public void testMutableSetInterfaces() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
            }

            @TestMetadata("notNullAnyMC.kt")
            public void testNotNullAnyMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
            }

            @TestMetadata("notNullParamMC.kt")
            public void testNotNullParamMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
            }

            @TestMetadata("nullableAnyMC.kt")
            public void testNullableAnyMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallableReference extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCallableReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/inline.kt");
        }

        @TestMetadata("nameIntrinsicWithImplicitThis.kt")
        public void testNameIntrinsicWithImplicitThis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CapturedVarsOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("capturedInChainOfInlineFuns.kt")
        public void testCapturedInChainOfInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
        }

        @TestMetadata("capturedInInlineOnly.kt")
        public void testCapturedInInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
        }

        @TestMetadata("capturedInLocalObject.kt")
        public void testCapturedInLocalObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
        }

        @TestMetadata("capturedInNoInlineOnly.kt")
        public void testCapturedInNoInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
        }

        @TestMetadata("capturedInNoInlneInsideChainOfInlineFuns.kt")
        public void testCapturedInNoInlneInsideChainOfInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
        }

        @TestMetadata("capturedVarsOfSize2.kt")
        public void testCapturedVarsOfSize2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
        }

        @TestMetadata("sharedSlotsWithCapturedVars.kt")
        public void testSharedSlotsWithCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
        }

        @TestMetadata("withStackNormalization.kt")
        public void testWithStackNormalization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/checkcast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Checkcast extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCheckcast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt14811.kt")
        public void testKt14811() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
        }

        @TestMetadata("kt14963.kt")
        public void testKt14963() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
        }

        @TestMetadata("kt15411.kt")
        public void testKt15411() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
        }

        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CoercionToUnitOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCoercionToUnitOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inRangeCheckWithConst.kt")
        public void testInRangeCheckWithConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
        }

        @TestMetadata("kt14360.kt")
        public void testKt14360() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
        }

        @TestMetadata("largeMethodWithCoercionToUnit.kt")
        public void testLargeMethodWithCoercionToUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
        }

        @TestMetadata("nopInlineFuns.kt")
        public void testNopInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
        }

        @TestMetadata("returnsUnit.kt")
        public void testReturnsUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
        }

        @TestMetadata("safeCallWithReturnValue.kt")
        public void testSafeCallWithReturnValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
        }

        @TestMetadata("safeLet.kt")
        public void testSafeLet() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
        }

        @TestMetadata("tryInlined.kt")
        public void testTryInlined() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/companion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Companion extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCompanion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt14258_1.kt")
        public void testKt14258_1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
        }

        @TestMetadata("kt14258_2.kt")
        public void testKt14258_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
        }

        @TestMetadata("kt14258_3.kt")
        public void testKt14258_3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
        }

        @TestMetadata("kt14258_4.kt")
        public void testKt14258_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
        }

        @TestMetadata("kt14258_5.kt")
        public void testKt14258_5() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Conditions extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConditions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conjuction.kt")
        public void testConjuction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/conjuction.kt");
        }

        @TestMetadata("disjunction.kt")
        public void testDisjunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
        }

        @TestMetadata("negatedConjuction.kt")
        public void testNegatedConjuction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
        }

        @TestMetadata("negatedDisjunction.kt")
        public void testNegatedDisjunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
        }

        @TestMetadata("negatedNullCompare.kt")
        public void testNegatedNullCompare() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompare.kt");
        }

        @TestMetadata("negatedZeroCompare.kt")
        public void testNegatedZeroCompare() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompare.kt");
        }

        @TestMetadata("noBoxingForBoxedEqPrimitive.kt")
        public void testNoBoxingForBoxedEqPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
        }

        @TestMetadata("noBoxingForPrimitiveEqBoxed.kt")
        public void testNoBoxingForPrimitiveEqBoxed() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
        }

        @TestMetadata("noBoxingForPrimitiveEqObject.kt")
        public void testNoBoxingForPrimitiveEqObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
        }

        @TestMetadata("nullCompare.kt")
        public void testNullCompare() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompare.kt");
        }

        @TestMetadata("zeroCompare.kt")
        public void testZeroCompare() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompare.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstProperty extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessorsForPrivateConstants.kt")
        public void testAccessorsForPrivateConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/accessorsForPrivateConstants.kt");
        }

        public void testAllFilesPresentInConstProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noAccessorsForPrivateConstants.kt")
        public void testNoAccessorsForPrivateConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
        }

        @TestMetadata("noInline.kt")
        public void testNoInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/noInline.kt");
        }

        @TestMetadata("noInlineInCmp.kt")
        public void testNoInlineInCmp() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/noInlineInCmp.kt");
        }

        @TestMetadata("nonConstValHasNoDefaultValue_after.kt")
        public void testNonConstValHasNoDefaultValue_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
        }

        @TestMetadata("nonConstValHasNoDefaultValue_before.kt")
        public void testNonConstValHasNoDefaultValue_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/constantConditions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstantConditions extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConstantConditions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("cmpIntWith0.kt")
        public void testCmpIntWith0() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
        }

        @TestMetadata("constantFlag.kt")
        public void testConstantFlag() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
        }

        @TestMetadata("constantInt.kt")
        public void testConstantInt() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
        }

        @TestMetadata("inlineIfFalse.kt")
        public void testInlineIfFalse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
        }

        @TestMetadata("kt3098.kt")
        public void testKt3098() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constants extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
        }

        @TestMetadata("inlineUnsignedIntConstant.kt")
        public void testInlineUnsignedIntConstant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
        }

        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
        }

        @TestMetadata("noInlineNonConst.kt")
        public void testNoInlineNonConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
        }

        @TestMetadata("noInlineNonStaticJavaField.kt")
        public void testNoInlineNonStaticJavaField() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
        }

        @TestMetadata("noInlineNonStaticJavaField_lv10.kt")
        public void testNoInlineNonStaticJavaField_lv10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField_lv10.kt");
        }

        @TestMetadata("nullableByteAndShort.kt")
        public void testNullableByteAndShort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
        }

        @TestMetadata("partialString.kt")
        public void testPartialString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ControlStructures extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInControlStructures() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Coroutines extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
            KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCoroutines() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("crossinlineSuspendContinuation_1_2.kt")
        public void testCrossinlineSuspendContinuation_1_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_2.kt");
        }

        @TestMetadata("crossinlineSuspendContinuation_1_3.kt")
        public void testCrossinlineSuspendContinuation_1_3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
        }

        @TestMetadata("doNotReassignContinuation.kt")
        public void testDoNotReassignContinuation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
        }

        @TestMetadata("doNotReassignContinuation_1_2.kt")
        public void testDoNotReassignContinuation_1_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation_1_2.kt");
        }

        @TestMetadata("returnUnitInLambda.kt")
        public void testReturnUnitInLambda_1_2() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt", "kotlin.coroutines.experimental");
        }

        @TestMetadata("returnUnitInLambda.kt")
        public void testReturnUnitInLambda_1_3() throws Exception {
            runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt", "kotlin.coroutines");
        }

        @TestMetadata("throwOnFailure.kt")
        public void testThrowOnFailure() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
        }

        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
        }

        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @TestMetadata("varValueConflictsWithTableSameSort_1_2.kt")
        public void testVarValueConflictsWithTableSameSort_1_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort_1_2.kt");
        }

        @TestMetadata("varValueConflictsWithTable_1_2.kt")
        public void testVarValueConflictsWithTable_1_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable_1_2.kt");
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Debug extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDebug() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("continuationInLvt.kt")
            public void testContinuationInLvt() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
            }

            @TestMetadata("localVariableCorrectLabel.kt")
            public void testLocalVariableCorrectLabel() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
            }

            @TestMetadata("probeCoroutineSuspended.kt")
            public void testProbeCoroutineSuspended() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
            }

            @TestMetadata("thisAndResultInLvt.kt")
            public void testThisAndResultInLvt() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DestructuringInLambda extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDestructuringInLambda() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inlineSeparateFiles.kt")
            public void testInlineSeparateFiles() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntLikeVarSpilling extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            private void runTestWithPackageReplacement(String testDataFilePath, String packageName) throws Exception {
                KotlinTestUtils.runTest(filePath -> doTestWithCoroutinesPackageReplacement(filePath, packageName), TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt", "kotlin.coroutines");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("i2bResult.kt")
            public void testI2bResult_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt", "kotlin.coroutines");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt", "kotlin.coroutines");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt", "kotlin.coroutines");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt", "kotlin.coroutines");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt", "kotlin.coroutines");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore_1_2() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt", "kotlin.coroutines.experimental");
            }

            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore_1_3() throws Exception {
                runTestWithPackageReplacement("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt", "kotlin.coroutines");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class StateMachine extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInStateMachine() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("kt25893.kt")
            public void testKt25893() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
            }

            @TestMetadata("withTypeParameter.kt")
            public void testWithTypeParameter() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeadCodeElimination extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
        }

        @TestMetadata("boxing.kt")
        public void testBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
        }

        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
        }

        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
        }

        @TestMetadata("lastReturn.kt")
        public void testLastReturn() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
        }

        @TestMetadata("literal.kt")
        public void testLiteral() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
        }

        @TestMetadata("simpleConstructor.kt")
        public void testSimpleConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
        }

        @TestMetadata("simpleConstructorNotRedundant.kt")
        public void testSimpleConstructorNotRedundant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DefaultArguments extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt11962.kt")
        public void testKt11962() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
        }

        @TestMetadata("maskAndArgumentElimination.kt")
        public void testMaskAndArgumentElimination() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
        }

        @TestMetadata("methodHandlerElimination.kt")
        public void testMethodHandlerElimination() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DirectInvoke extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDirectInvoke() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
        }

        @TestMetadata("inplaceClosure.kt")
        public void testInplaceClosure() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExclExcl extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInExclExcl() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ForLoop extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInForLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
        }

        @TestMetadata("forInOptimizableUnsignedRange.kt")
        public void testForInOptimizableUnsignedRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInOptimizableUnsignedRange.kt");
        }

        @TestMetadata("forInRangeSpecializedToUntil.kt")
        public void testForInRangeSpecializedToUntil() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
        }

        @TestMetadata("forInRangeToCharConst.kt")
        public void testForInRangeToCharConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
        }

        @TestMetadata("forInRangeToConst.kt")
        public void testForInRangeToConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
        }

        @TestMetadata("forInRangeToLongConst.kt")
        public void testForInRangeToLongConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
        }

        @TestMetadata("forInRangeToQualifiedConst.kt")
        public void testForInRangeToQualifiedConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
        }

        @TestMetadata("forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
        }

        @TestMetadata("forInStringSpecialized.kt")
        public void testForInStringSpecialized() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
        }

        @TestMetadata("forInUntil.kt")
        public void testForInUntil() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil.kt");
        }

        @TestMetadata("forIntInDownTo.kt")
        public void testForIntInDownTo() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
        }

        @TestMetadata("intrinsicArrayConstructorsUseCounterLoop.kt")
        public void testIntrinsicArrayConstructorsUseCounterLoop() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
        }

        @TestMetadata("loopVarInterval.kt")
        public void testLoopVarInterval() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
        }

        @TestMetadata("primitiveLiteralRange1.kt")
        public void testPrimitiveLiteralRange1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
        }

        @TestMetadata("primitiveLiteralRange2.kt")
        public void testPrimitiveLiteralRange2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
        }

        @TestMetadata("primitiveProgression.kt")
        public void testPrimitiveProgression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
        }

        @TestMetadata("primitiveRange.kt")
        public void testPrimitiveRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInArrayWithIndex extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInArrrayWithIndexNoElementVar.kt")
            public void testForInArrrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrrayWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInArrrayWithIndexNoIndexVar.kt")
            public void testForInArrrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrrayWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInEmptyArrrayWithIndex.kt")
            public void testForInEmptyArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrrayWithIndex.kt");
            }

            @TestMetadata("forInIntArrrayWithIndex.kt")
            public void testForInIntArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrrayWithIndex.kt");
            }

            @TestMetadata("forInObjectArrrayWithIndex.kt")
            public void testForInObjectArrrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrrayWithIndex.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInCharSequenceWithIndex extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIndices extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInIndices() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
            }

            @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
            }

            @TestMetadata("forInCollectionIndices.kt")
            public void testForInCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
            }

            @TestMetadata("forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
            }

            @TestMetadata("forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
            }

            @TestMetadata("forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInIterableWithIndex extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInReversed extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInReversed() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInReversedArrayIndices.kt")
            public void testForInReversedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
            }

            @TestMetadata("forInReversedCharSequenceIndices.kt")
            public void testForInReversedCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
            }

            @TestMetadata("forInReversedCollectionIndices.kt")
            public void testForInReversedCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
            }

            @TestMetadata("forInReversedDownTo.kt")
            public void testForInReversedDownTo() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
            }

            @TestMetadata("forInReversedEmptyRangeLiteral.kt")
            public void testForInReversedEmptyRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
            }

            @TestMetadata("forInReversedRange.kt")
            public void testForInReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
            }

            @TestMetadata("forInReversedRangeLiteral.kt")
            public void testForInReversedRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
            }

            @TestMetadata("ForInReversedReversedRange.kt")
            public void testForInReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/ForInReversedReversedRange.kt");
            }

            @TestMetadata("forInReversedReversedReversedRange.kt")
            public void testForInReversedReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
            }

            @TestMetadata("forInReversedUntil.kt")
            public void testForInReversedUntil() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForInSequenceWithIndex extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/hashCode")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class HashCode extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInHashCode() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hashCode.kt")
        public void testHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/hashCode/hashCode.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ieee754 extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIeee754() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
        }

        @TestMetadata("nullableDoubleEquals10.kt")
        public void testNullableDoubleEquals10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals10.kt");
        }

        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
        }

        @TestMetadata("nullableDoubleNotEquals10.kt")
        public void testNullableDoubleNotEquals10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals10.kt");
        }

        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
        }

        @TestMetadata("nullableFloatEquals10.kt")
        public void testNullableFloatEquals10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals10.kt");
        }

        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
        }

        @TestMetadata("nullableFloatNotEquals10.kt")
        public void testNullableFloatNotEquals10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals10.kt");
        }

        @TestMetadata("smartCastsForDouble.kt")
        public void testSmartCastsForDouble() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
        }

        @TestMetadata("smartCastsForDouble10.kt")
        public void testSmartCastsForDouble10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble10.kt");
        }

        @TestMetadata("smartCastsForFloat.kt")
        public void testSmartCastsForFloat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
        }

        @TestMetadata("smartCastsForFloat10.kt")
        public void testSmartCastsForFloat10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat10.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
        }

        @TestMetadata("when10.kt")
        public void testWhen10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/when10.kt");
        }

        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
        }

        @TestMetadata("whenNullableSmartCast10.kt")
        public void testWhenNullableSmartCast10() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast10.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inline extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("deleteClassOnTransfromation.kt")
        public void testDeleteClassOnTransfromation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransfromation.kt");
        }

        @TestMetadata("finallyMarkers.kt")
        public void testFinallyMarkers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
        }

        @TestMetadata("inlineArgumentSlots.kt")
        public void testInlineArgumentSlots() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
        }

        @TestMetadata("inlineReturnsNothing1.kt")
        public void testInlineReturnsNothing1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
        }

        @TestMetadata("inlineReturnsNothing2.kt")
        public void testInlineReturnsNothing2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
        }

        @TestMetadata("inlineReturnsNothing3.kt")
        public void testInlineReturnsNothing3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
        }

        @TestMetadata("inlineSuspendReifiedNoSpilling.kt")
        public void testInlineSuspendReifiedNoSpilling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
        }

        @TestMetadata("linenumberForOneParametersArgumentCall.kt")
        public void testLinenumberForOneParametersArgumentCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
        }

        @TestMetadata("noSynAccessor.kt")
        public void testNoSynAccessor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
        }

        @TestMetadata("noSynAccessorToDirectFieldAccess.kt")
        public void testNoSynAccessorToDirectFieldAccess() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
        }

        @TestMetadata("noSynAccessorToSuper.kt")
        public void testNoSynAccessorToSuper() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
        }

        @TestMetadata("notSplitedExceptionTable.kt")
        public void testNotSplitedExceptionTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
        }

        @TestMetadata("reifiedSafeAsWithMutable.kt")
        public void testReifiedSafeAsWithMutable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
        }

        @TestMetadata("remappedLocalVar.kt")
        public void testRemappedLocalVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
        }

        @TestMetadata("removedFinallyMarkers.kt")
        public void testRemovedFinallyMarkers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
        }

        @TestMetadata("specialEnumFunction.kt")
        public void testSpecialEnumFunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
        }

        @TestMetadata("splitedExceptionTable.kt")
        public void testSplitedExceptionTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
        }

        @TestMetadata("whenMappingOnCallSite.kt")
        public void testWhenMappingOnCallSite() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/inline/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("asCastForInlineClass.kt")
        public void testAsCastForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
        }

        @TestMetadata("assertionsForParametersOfInlineClassTypes.kt")
        public void testAssertionsForParametersOfInlineClassTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
        }

        @TestMetadata("boxInlineClassInsideElvisWithNullConstant.kt")
        public void testBoxInlineClassInsideElvisWithNullConstant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
        }

        @TestMetadata("boxInlineClassesOnPassingToVarargs.kt")
        public void testBoxInlineClassesOnPassingToVarargs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
        }

        @TestMetadata("boxMethodCalledByInlineClass.kt")
        public void testBoxMethodCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
        }

        @TestMetadata("boxResultAfterConstructorCall.kt")
        public void testBoxResultAfterConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
        }

        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
        }

        @TestMetadata("boxThisOfInlineClass.kt")
        public void testBoxThisOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
        }

        @TestMetadata("boxUnboxInlineClassFromMethodReturnType.kt")
        public void testBoxUnboxInlineClassFromMethodReturnType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
        }

        @TestMetadata("boxUnboxInsideLambdaAsLastExpression.kt")
        public void testBoxUnboxInsideLambdaAsLastExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
        }

        @TestMetadata("boxUnboxOfInlineClassesWithFunctionalTypes.kt")
        public void testBoxUnboxOfInlineClassesWithFunctionalTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
        }

        @TestMetadata("boxUnboxOnInlinedParameters.kt")
        public void testBoxUnboxOnInlinedParameters() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
        }

        @TestMetadata("boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
        public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
        }

        @TestMetadata("callMemberMethodsInsideInlineClass.kt")
        public void testCallMemberMethodsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
        }

        @TestMetadata("checkOuterInlineFunctionCall.kt")
        public void testCheckOuterInlineFunctionCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
        }

        @TestMetadata("equalsIsCalledByInlineClass.kt")
        public void testEqualsIsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
        }

        @TestMetadata("factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
        public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
        }

        @TestMetadata("functionsWithInlineClassParametersHaveStableMangledNames.kt")
        public void testFunctionsWithInlineClassParametersHaveStableMangledNames() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
        }

        @TestMetadata("generationOfAccessorToUnderlyingValue.kt")
        public void testGenerationOfAccessorToUnderlyingValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
        }

        @TestMetadata("hashCodeIsCalledByInlineClass.kt")
        public void testHashCodeIsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
        }

        @TestMetadata("inlineClassBoxingOnAssignment.kt")
        public void testInlineClassBoxingOnAssignment() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
        }

        @TestMetadata("inlineClassBoxingOnFunctionCall.kt")
        public void testInlineClassBoxingOnFunctionCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
        }

        @TestMetadata("inlineClassBoxingUnboxingInsideInlinedLambda.kt")
        public void testInlineClassBoxingUnboxingInsideInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
        }

        @TestMetadata("inlineClassInGeneratedToString.kt")
        public void testInlineClassInGeneratedToString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
        }

        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
        }

        @TestMetadata("inlineClassesUnboxingAfterAssertionOperator.kt")
        public void testInlineClassesUnboxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
        }

        @TestMetadata("isCheckForInlineClass.kt")
        public void testIsCheckForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
        }

        @TestMetadata("noActualCallsOfInlineFunctionsOfInlineClass.kt")
        public void testNoActualCallsOfInlineFunctionsOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
        }

        @TestMetadata("noAssertionsForInlineClassesBasedOnNullableTypes.kt")
        public void testNoAssertionsForInlineClassesBasedOnNullableTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
        }

        @TestMetadata("noBoxingOnCastOperations.kt")
        public void testNoBoxingOnCastOperations() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
        }

        @TestMetadata("noBoxingOperationsOnNonTrivialSpread.kt")
        public void testNoBoxingOperationsOnNonTrivialSpread() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
        }

        @TestMetadata("noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
        public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
        }

        @TestMetadata("nonOverridingMethodsAreCalledByInlineClass.kt")
        public void testNonOverridingMethodsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
        }

        @TestMetadata("overridingMethodsAreCalledByInlineClass.kt")
        public void testOverridingMethodsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
        }

        @TestMetadata("passInlineClassesWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassesWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
        }

        @TestMetadata("primaryConstructorCalledByInlineClass.kt")
        public void testPrimaryConstructorCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
        }

        @TestMetadata("propertyAccessorsAreCalledByInlineClass.kt")
        public void testPropertyAccessorsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
        }

        @TestMetadata("propertySetterWithInlineClassTypeArgument.kt")
        public void testPropertySetterWithInlineClassTypeArgument() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
        }

        @TestMetadata("resultApiDoesntUseBox.kt")
        public void testResultApiDoesntUseBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
        }

        @TestMetadata("skipCallToUnderlyingValueOfInlineClass.kt")
        public void testSkipCallToUnderlyingValueOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
        }

        @TestMetadata("toStringIsCalledByInlineClass.kt")
        public void testToStringIsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringIsCalledByInlineClass.kt");
        }

        @TestMetadata("uIntArrayIteratorWithoutBoxing.kt")
        public void testUIntArrayIteratorWithoutBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
        }

        @TestMetadata("uIntArraySwapBoxing.kt")
        public void testUIntArraySwapBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
        }

        @TestMetadata("unboxInlineClassAfterElvis.kt")
        public void testUnboxInlineClassAfterElvis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
        }

        @TestMetadata("unboxInlineClassAfterSafeCall.kt")
        public void testUnboxInlineClassAfterSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
        }

        @TestMetadata("unboxInlineClassFromParameterizedType.kt")
        public void testUnboxInlineClassFromParameterizedType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
        }

        @TestMetadata("unboxInlineClassesAfterSmartCasts.kt")
        public void testUnboxInlineClassesAfterSmartCasts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
        }

        @TestMetadata("unboxMethodCalledByInlineClass.kt")
        public void testUnboxMethodCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Interfaces extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInterfaces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("firstInheritedMethodIsAbstract.kt")
        public void testFirstInheritedMethodIsAbstract() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
        }

        @TestMetadata("noAnyMethodsOnInterfaceInheritance.kt")
        public void testNoAnyMethodsOnInterfaceInheritance() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
        }

        @TestMetadata("noPrivateMemberInJavaInterface.kt")
        public void testNoPrivateMemberInJavaInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
        }

        @TestMetadata("traitImplGeneratedOnce.kt")
        public void testTraitImplGeneratedOnce() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Intrinsics extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIntrinsics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("javaObjectType.kt")
        public void testJavaObjectType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
        }

        @TestMetadata("javaPrimitiveType.kt")
        public void testJavaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsicsCompare")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntrinsicsCompare extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIntrinsicsCompare() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("byteSmartCast.kt")
        public void testByteSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast.kt");
        }

        @TestMetadata("charSmartCast.kt")
        public void testCharSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
        }

        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes.kt");
        }

        @TestMetadata("intSmartCast.kt")
        public void testIntSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast.kt");
        }

        @TestMetadata("longSmartCast.kt")
        public void testLongSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
        }

        @TestMetadata("shortSmartCast.kt")
        public void testShortSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/jackAndJill")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JackAndJill extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJackAndJill() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jackAndJill"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineDefaultBodyInClass.kt")
        public void testInlineDefaultBodyInClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/jackAndJill/inlineDefaultBodyInClass.kt");
        }

        @TestMetadata("inlinedConstuctor.kt")
        public void testInlinedConstuctor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/jackAndJill/inlinedConstuctor.kt");
        }

        @TestMetadata("inlinedConstuctorWithSuperCallParams.kt")
        public void testInlinedConstuctorWithSuperCallParams() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/jackAndJill/inlinedConstuctorWithSuperCallParams.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Jvm8 extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJvm8() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class HashCode extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInHashCode() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dataClass.kt")
            public void testDataClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
            }

            @TestMetadata("hashCode.kt")
            public void testHashCode() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
            }
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JvmDefault extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJvmDefault() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Compatibility extends AbstractBytecodeTextTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCompatibility() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/defaultArgs.kt");
                }

                @TestMetadata("simpleFunction.kt")
                public void testSimpleFunction() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleFunction.kt");
                }

                @TestMetadata("simpleFunctionWithAbstractOverride.kt")
                public void testSimpleFunctionWithAbstractOverride() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleFunctionWithAbstractOverride.kt");
                }

                @TestMetadata("simpleProperty.kt")
                public void testSimpleProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleProperty.kt");
                }
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LazyCodegen extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineConstInsideComparison.kt")
        public void testInlineConstInsideComparison() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
        }

        @TestMetadata("negateConst.kt")
        public void testNegateConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
        }

        @TestMetadata("negateConstantCompare.kt")
        public void testNegateConstantCompare() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConstantCompare.kt");
        }

        @TestMetadata("negateObjectComp.kt")
        public void testNegateObjectComp() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
        }

        @TestMetadata("negateObjectCompChaing.kt")
        public void testNegateObjectCompChaing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
        }

        @TestMetadata("negateVar.kt")
        public void testNegateVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
        }

        @TestMetadata("negateVarChain.kt")
        public void testNegateVarChain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LineNumbers extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLineNumbers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
        }

        @TestMetadata("singleThen.kt")
        public void testSingleThen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/localInitializationLVT")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalInitializationLVT extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLocalInitializationLVT() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boxing.kt")
        public void testBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
        }

        @TestMetadata("boxingVar.kt")
        public void testBoxingVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
        }

        @TestMetadata("contract.kt")
        public void testContract() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
        }

        @TestMetadata("contractVar.kt")
        public void testContractVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
        }

        @TestMetadata("genericsVar.kt")
        public void testGenericsVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
        }

        @TestMetadata("ifStatement.kt")
        public void testIfStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
        }

        @TestMetadata("ifStatementVar.kt")
        public void testIfStatementVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
        }

        @TestMetadata("ifStatementWithoutBlock.kt")
        public void testIfStatementWithoutBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
        }

        @TestMetadata("ifStatementWithoutBlockVar.kt")
        public void testIfStatementWithoutBlockVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
        }

        @TestMetadata("inlineClass.kt")
        public void testInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
        }

        @TestMetadata("inlineClassVar.kt")
        public void testInlineClassVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
        }

        @TestMetadata("lateinit.kt")
        public void testLateinit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
        }

        @TestMetadata("run.kt")
        public void testRun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
        }

        @TestMetadata("runVar.kt")
        public void testRunVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
        }

        @TestMetadata("singleBlock.kt")
        public void testSingleBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
        }

        @TestMetadata("singleBlockVar.kt")
        public void testSingleBlockVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
        }

        @TestMetadata("whenStatement.kt")
        public void testWhenStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
        }

        @TestMetadata("whenStatementVar.kt")
        public void testWhenStatementVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/mangling")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Mangling extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMangling() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("parentheses.kt")
        public void testParentheses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
        }

        @TestMetadata("parenthesesNoSanitize.kt")
        public void testParenthesesNoSanitize() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MultifileClasses extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("optimizedMultifileClassFacadeMethods.kt")
        public void testOptimizedMultifileClassFacadeMethods() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NullCheckOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNullCheckOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyCheckedForIs.kt")
        public void testAlreadyCheckedForIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
        }

        @TestMetadata("alreadyCheckedForNull.kt")
        public void testAlreadyCheckedForNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
        }

        @TestMetadata("deterministicNotNullChecks.kt")
        public void testDeterministicNotNullChecks() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
        }

        @TestMetadata("expressionValueIsNotNull.kt")
        public void testExpressionValueIsNotNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
        }

        @TestMetadata("expressionValueIsNotNullAfterExclExcl.kt")
        public void testExpressionValueIsNotNullAfterExclExcl() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
        }

        @TestMetadata("expressionValueIsNotNullTwice.kt")
        public void testExpressionValueIsNotNullTwice() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
        }

        @TestMetadata("ifNullEqualsNull.kt")
        public void testIfNullEqualsNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
        }

        @TestMetadata("ifNullEqualsNullInline.kt")
        public void testIfNullEqualsNullInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
        }

        @TestMetadata("ifUnitEqualsNull.kt")
        public void testIfUnitEqualsNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
        }

        @TestMetadata("ifUnitEqualsNullInline.kt")
        public void testIfUnitEqualsNullInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
        }

        @TestMetadata("kt12839.kt")
        public void testKt12839() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
        }

        @TestMetadata("notNullAsNotNullable.kt")
        public void testNotNullAsNotNullable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
        }

        @TestMetadata("primitiveCheck.kt")
        public void testPrimitiveCheck() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
        }

        @TestMetadata("redundantSafeCall.kt")
        public void testRedundantSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
        }

        @TestMetadata("reifiedIs.kt")
        public void testReifiedIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
        }

        @TestMetadata("reifiedNullIs.kt")
        public void testReifiedNullIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
        }

        @TestMetadata("trivialInstanceOf.kt")
        public void testTrivialInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class LocalLateinit extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLocalLateinit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("checkedAlways.kt")
            public void testCheckedAlways() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
            }

            @TestMetadata("checkedOnce.kt")
            public void testCheckedOnce() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
            }

            @TestMetadata("initialized.kt")
            public void testInitialized() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/testData/codegen/bytecodeText/properties/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lateinit extends AbstractBytecodeTextTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLateinit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
            }

            @TestMetadata("companionObjectFromLambda.kt")
            public void testCompanionObjectFromLambda() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
            }
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Ranges extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRanges() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifNotInRange.kt")
        public void testIfNotInRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
        }

        @TestMetadata("inArrayIndices.kt")
        public void testInArrayIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
        }

        @TestMetadata("inCharSequenceIndices.kt")
        public void testInCharSequenceIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
        }

        @TestMetadata("inCollectionIndices.kt")
        public void testInCollectionIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
        }

        @TestMetadata("inComparableRangeLiteral.kt")
        public void testInComparableRangeLiteral() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
        }

        @TestMetadata("inNonMatchingRangeIntrinsified.kt")
        public void testInNonMatchingRangeIntrinsified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
        }

        @TestMetadata("inNonMatchingRangeNotIntrinsified.kt")
        public void testInNonMatchingRangeNotIntrinsified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeNotIntrinsified.kt");
        }

        @TestMetadata("inOptimizableRange.kt")
        public void testInOptimizableRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
        }

        @TestMetadata("inOptimizableUnsignedRange.kt")
        public void testInOptimizableUnsignedRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
        }

        @TestMetadata("inUntil.kt")
        public void testInUntil() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
        }

        @TestMetadata("noDupXForLiteralRangeContains.kt")
        public void testNoDupXForLiteralRangeContains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/sam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Sam extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("samWrapperForNullInitialization.kt")
        public void testSamWrapperForNullInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
        }

        @TestMetadata("samWrapperForNullableInitialization.kt")
        public void testSamWrapperForNullableInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Statements extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStatements() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifSingleBranch.kt")
        public void testIfSingleBranch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
        }

        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
        }

        @TestMetadata("ifThenElseEmpty.kt")
        public void testIfThenElseEmpty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
        }

        @TestMetadata("labeled.kt")
        public void testLabeled() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
        }

        @TestMetadata("statementsComposition.kt")
        public void testStatementsComposition() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
        }

        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
        }

        @TestMetadata("whenSubject.kt")
        public void testWhenSubject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StaticFields extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStaticFields() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StoreStackBeforeInline extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStoreStackBeforeInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
        }

        @TestMetadata("primitiveMerge.kt")
        public void testPrimitiveMerge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
        }

        @TestMetadata("unreachableMarker.kt")
        public void testUnreachableMarker() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
        }

        @TestMetadata("withLambda.kt")
        public void testWithLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StringOperations extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStringOperations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("concat.kt")
        public void testConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
        }

        @TestMetadata("doNotAppendEmptyString.kt")
        public void testDoNotAppendEmptyString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
        }

        @TestMetadata("interpolation.kt")
        public void testInterpolation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
        }

        @TestMetadata("kt15235.kt")
        public void testKt15235() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
        }

        @TestMetadata("kt19037.kt")
        public void testKt19037() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
        }

        @TestMetadata("nestedConcat.kt")
        public void testNestedConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
        }

        @TestMetadata("nonNullableStringPlus.kt")
        public void testNonNullableStringPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
        }

        @TestMetadata("nullableStringPlus.kt")
        public void testNullableStringPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
        }

        @TestMetadata("primitiveToString.kt")
        public void testPrimitiveToString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
        }

        @TestMetadata("primitivesAsStringTemplates.kt")
        public void testPrimitivesAsStringTemplates() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/unsignedTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnsignedTypes extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnsignedTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("unsignedLongDivide_jvm16.kt")
        public void testUnsignedLongDivide_jvm16() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm16.kt");
        }

        @TestMetadata("unsignedLongDivide_jvm18.kt")
        public void testUnsignedLongDivide_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
        }

        @TestMetadata("unsignedLongRemainder_jvm16.kt")
        public void testUnsignedLongRemainder_jvm16() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm16.kt");
        }

        @TestMetadata("unsignedLongRemainder_jvm18.kt")
        public void testUnsignedLongRemainder_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
        }

        @TestMetadata("whenByUnsigned.kt")
        public void testWhenByUnsigned() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/varargs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Varargs extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInVarargs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doNotCopyImmediatelyCreatedArrays.kt")
        public void testDoNotCopyImmediatelyCreatedArrays() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
        }

        @TestMetadata("exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
        }

        @TestMetadata("exhaustiveWhenUnit.kt")
        public void testExhaustiveWhenUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
        }

        @TestMetadata("exhaustiveWhenUnitStatement.kt")
        public void testExhaustiveWhenUnitStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
        }

        @TestMetadata("inlineConstValsInsideWhen.kt")
        public void testInlineConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
        }

        @TestMetadata("integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
        }

        @TestMetadata("kt18818.kt")
        public void testKt18818() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
        }

        @TestMetadata("noBoxingInDefaultWhenWithSpecialCases.kt")
        public void testNoBoxingInDefaultWhenWithSpecialCases() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
        }

        @TestMetadata("qualifiedConstValsInsideWhen.kt")
        public void testQualifiedConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
        }

        @TestMetadata("sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
        }

        @TestMetadata("simpleConstValsInsideWhen.kt")
        public void testSimpleConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
        }

        @TestMetadata("subjectValHasLocalVariableSlot.kt")
        public void testSubjectValHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
        }

        @TestMetadata("subjectValInEnumWhenHasLocalVariableSlot.kt")
        public void testSubjectValInEnumWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
        }

        @TestMetadata("subjectValInIntWhenHasLocalVariableSlot.kt")
        public void testSubjectValInIntWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
        }

        @TestMetadata("subjectValInStringWhenHasLocalVariableSlot.kt")
        public void testSubjectValInStringWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
        }

        @TestMetadata("whenNull.kt")
        public void testWhenNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
        }

        @TestMetadata("whenZero.kt")
        public void testWhenZero() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WhenEnumOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWhenEnumOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("bigEnum.kt")
        public void testBigEnum() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
        }

        @TestMetadata("differentEnumClasses.kt")
        public void testDifferentEnumClasses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
        }

        @TestMetadata("differentEnumClasses2.kt")
        public void testDifferentEnumClasses2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
        }

        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
        }

        @TestMetadata("functionLiteralInTopLevel.kt")
        public void testFunctionLiteralInTopLevel() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
        }

        @TestMetadata("importedEnumEntry.kt")
        public void testImportedEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
        }

        @TestMetadata("kt14597_full.kt")
        public void testKt14597_full() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
        }

        @TestMetadata("kt14802.kt")
        public void testKt14802() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
        }

        @TestMetadata("kt15806.kt")
        public void testKt15806() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt15806.kt");
        }

        @TestMetadata("manyWhensWithinClass.kt")
        public void testManyWhensWithinClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
        }

        @TestMetadata("nonConstantEnum.kt")
        public void testNonConstantEnum() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
        }

        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
        }

        @TestMetadata("subjectAny.kt")
        public void testSubjectAny() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
        }

        @TestMetadata("withoutElse.kt")
        public void testWithoutElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
        }
    }

    @TestMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WhenStringOptimization extends AbstractBytecodeTextTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWhenStringOptimization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("denseHashCode.kt")
        public void testDenseHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
        }

        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
        }

        @TestMetadata("duplicatingItemsSameHashCode.kt")
        public void testDuplicatingItemsSameHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCode.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
        }

        @TestMetadata("inlineStringConstInsideWhen.kt")
        public void testInlineStringConstInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
        }

        @TestMetadata("nonInlinedConst.kt")
        public void testNonInlinedConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nonInlinedConst.kt");
        }

        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
        }

        @TestMetadata("sameHashCode.kt")
        public void testSameHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
        }

        @TestMetadata("statement.kt")
        public void testStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
        }
    }
}
